% TestFiltered.m
% Views and tests images filtered for VisNet. ETR April 2012.
% e.g. TestFiltered('image256.dat')
% Loads the complete set of gabor filters currently output by gaborfast512
% (assumes the filter files are in the current path)
% For VisNet, ang=0 is horizontal
% Visnet images are flat with no header and have all the values for row 1, then row 2, etc
% the images and filters therefore need to be transposed for viewing in Matlab

function [] =  TestFiltered(image_name)
 
close all hidden;
format compact;

Display = 1; % set to 1 to display all the filtered images; 0 for less display
% set to 2 to display also the neg and pos filtered images
base_dir = '/home/erolls/VisNetUtilities/gaborL2/'
base_dir = '/home/erolls/imagedata/faceL/'
base_dir = '/home/erolls/imagedata/faces/'
%base_dir = '/home/twebb/src/imagedata/'
image_dir = strcat(base_dir, image_name, '.filtered/')

fig = 0;

Fsize = 128; % the padded size of the image, and the size of the filtered images
Imsize = Fsize/2; % the size of the input image
recon = zeros(Fsize, Fsize); % we will add all the positive filtered images here to see how well this reconstructs the original image, as a data check
recon_neg = zeros(Fsize, Fsize); % we will add all the negative filtered images here to see how well this reconstructs the original image, as a data check

% open and read in the original image
%f_orig = fopen(strcat(image_dir, image_name,'.original256'), 'r');
%tmp = fread(f_orig, 'uint8=>uint8');
%fclose(f_orig);

%Image = reshape(single(tmp), [Imsize Imsize]); % for 512x512=262144 bytes
%Image = reshape(tmp, [256 256]); % for 256x256=65536 bytes
%ImageMean = mean2(Image)
%ImageStd = std2(Image)
%if (Display >= 1)
%    fig = fig + 1;
%    figure(fig);
%    imagesc(Image'); title('Image .original256');
%    colormap(gray);
%    pause;
%end

% check the 128x128 image used by VisNet for its image display.
f_sub = fopen(strcat(image_dir, image_name,'.image'), 'r');
tmp = fread(f_sub, 'uint8=>uint8');
% sub_sampled_image = uint8(reshape(sub_sampled_image',[1 Imsize/2 * Imsize/2]));
fclose(f_sub);
Image = reshape(single(tmp), [128 128]); % always 128x128
if (Display >= 1)
    fig = fig + 1;
    figure(fig);
    imagesc(Image'); title('Display .image 128x128');
    colormap(gray);
    pause;
end


% List of frequencies and angles to iterate over
%freqList = [1 2 4 8 16 32 64];
freqList = [1 2 4 8];
%freqList = [1 2 4 8 16 32];
symAngList = [ 0 45 90 135]; % the symmetrical filters
asymAngList = [ 0 45 90 135 180 225 270 315]; % the asymmetrical filters

% load each filtered image, display it, and add it to the image being reconstructed
index = 1;
fig = fig + 1;
figure(fig);
for freq = freqList
    for ang = symAngList
        freq
        ang

        
        fid_pos = fopen (strcat(image_dir,image_name, '.', int2str(freq), '.', int2str(ang),'.p'),'r');
        posim = fread(fid_pos, [Fsize Fsize]);
        fclose(fid_pos);
        recon = recon + posim;

        fid_neg = fopen (strcat(image_dir,image_name, '.', int2str(freq), '.', int2str(ang),'.n'),'r');
        negim = fread(fid_neg, [Fsize Fsize]);
        fclose(fid_neg);
        recon_neg = recon_neg + negim;
        
        if (Display >= 1)
            freq;
            ang;
            % size(sym_tmp)
            subplot(length(freqList), length(symAngList), index);
            set(gca,'xtick',[],'ytick',[]);
            imagesc(posim');  
            meanVal = mean2(posim)
            stdVal = std2(posim)
            maxVal = floor(max(max(posim)))
            minVal = floor(min(min(posim)))
            title({['Max ' num2str(maxVal) ' Min ' num2str(minVal)  ]});
        end

        if (Display == 2)
            pause
            subplot(length(freqList), length(symAngList), index);
            set(gca,'xtick',[],'ytick',[]);
            imagesc(negim');  
            meanVal = mean2(negim)
            stdVal = std2(negim)
            maxVal = floor(max(max(negim)))
            minVal = floor(min(min(negim)))
            title({['NegIm Max ' num2str(maxVal) ' Min ' num2str(minVal)  ]});
         end
        
    index = index + 1;
    end
end
% colormap(gray);

if (Display >= 1)
    fig = fig + 1;
    figure(fig);
    imagesc(recon'); title('Reconstructed Image from positive filtered images');
    colormap(gray);
        
    fig = fig + 1;
    figure(fig);
    recon_neg = -recon_neg; % show the negative image as a positive picture
    imagesc(recon_neg'); title('Negative of Reconstructed Image from negative filtered images');
    colormap(gray);

    fig = fig + 1;
    figure(fig);
    reconboth = recon + recon_neg;
    imagesc(reconboth'); title('Reconstructed Image from both positive and negative filtered images');
    colormap(gray);
end


if (Display >= 1)
    pause;
    % display the gabor filters
    symFilters = cell(1, length(freqList)*length(symAngList)); % used just for the display
    asymFilters = cell(1, length(freq)*length(asymAngList));
    fig = fig + 1;
    figure(fig); % display the symmetrical filters
    title('Symmetric filters'); hold on;
    index = 1;
    for freq = freqList
        for ang = symAngList
            fid = fopen( strcat(filenameBase, '.', int2str(freq), '.', int2str(ang),'.dat') );
            symFilters{index} = fread(fid, [8*freq 8*freq], 'single'); 
            fclose(fid);
            
            subplot(length(freqList), length(symAngList), index);
            imagesc(symFilters{index}');
            %image(symFilters{index});
            set(gca,'xtick',[],'ytick',[]);
            index = index + 1;
        end
    end
    pause
    
    fig = fig + 1; % display the asymmetrical filters
    figure(fig);
    % title('Asymmetric filters'); hold on;
    index = 1;
    for freq = freqList
        for ang = asymAngList
            fid = fopen( strcat(filenameBase, 'a.', int2str(freq), '.', int2str(ang),'.dat') );
            asymFilters{index} = fread(fid, [8*freq 8*freq], 'single'); 
            fclose(fid);
            subplot(length(freqList), length(asymAngList), index);
            imagesc(asymFilters{index}');
            set(gca,'xtick',[],'ytick',[]);
            index = index + 1;
        end
    end
    title('Asymmetric filters'); hold on;   
end


    
    