function DisplaySynWeights(layer, epoch, group)
% show the SynWeights
% layer is in range 1-4
% copyright E T Rolls, Oxford Centre for Computational Neuroscience

global EFR EFRDATA NLAYERS NET_SIZE SQNET_SIZE N_FILES N_GROUPS N_VIEWS N_LOCS BESTCELLS NBESTCELLS ...
       NBESTCELLSINFORM NTRANSFORMS PARAMETER_LIST SYNMAT SYNMAT_CHANGE ...
       SYNMAT_CHANGE_GROUP LOGNUM FIXEDTRACE SPARSENESS BETA ETA LRNRATE NSYN SYNMATL1 SYNMATL2 SYNMATL3 ...
       SYNMATL4 VNLOGINDEX IMLIST IMLIST_TEST N_VIEWS_TEST FILTIM NSYNL1 Images base_dir image_dir ...
       FiltImSize SqFiltImSize Display ...
       filter_layer_1 filter_layer_2  filter_layer_3 filter_layer_4 SIGMOID LATERALINHIB TraceDisp DisplaySYNMATprevious

    if layer < 1
        layer = 1
    elseif layer > 4
        layer = 4
    end 
    
    SynapsesPerNeuron = NSYN(layer);
    DisplaySYNMAT = zeros(SynapsesPerNeuron, SQNET_SIZE);
    
    for i = 1 : SQNET_SIZE % i is the postsynaptic neuron number in the layer specified
        switch layer
            case 1
                SYNMATcol = SYNMATL1(:, i); % column-wise operations speed up the operations on the sparse matrix
            case 2
                SYNMATcol = SYNMATL2(:, i); % column-wise operations speed up the operations on the sparse matrix
             case 3
                SYNMATcol = SYNMATL3(:, i); % column-wise operations speed up the operations on the sparse matrix
             case 4
                SYNMATcol = SYNMATL4(:, i); % column-wise operations speed up the operations on the sparse matrix
        end       
        synapseIndex = find(SYNMATcol);
        DisplaySYNMAT(:, i) = SYNMATcol(synapseIndex);
    end
    figure(1000 + layer)
    imagesc(DisplaySYNMAT);
    title(['Synaptic weights layer ', num2str(layer)]);
    xlabel('Neuron');
    ylabel('Synapse');
    colormap(gray);
    c = colorbar;
    c.Label.String = 'synaptic weight';
    
    if group == 1 && epoch == 1
        DisplaySYNMATprevious = zeros(NSYN(layer), SQNET_SIZE); % this holds the previous syn weight matrix
    end
    
    SynMatChange = corr2(DisplaySYNMATprevious, DisplaySYNMAT); 
    SYNMAT_CHANGE_GROUP(layer, (epoch-1) * N_GROUPS + group) = SynMatChange;
    figure(6);
    plot(SYNMAT_CHANGE_GROUP(:, 1 : end)'); % the first point is the change from the initial random vector
    title('Correlation of synaptic weight matrix with previous group', 'FontWeight', 'normal'); xlabel('training epoch * NGROUPS'); ylabel('Correlation');
    legend('layer 1', 'layer 2', 'layer 3', 'layer 4', 'Location','southeast');
    %fprintf('epoch=%3d layer=%3d Group=%3d SynMatCorrelationWithPrevious =%8.7f\n', epoch, layer, group, SynMatChange);
    DisplaySYNMATprevious = DisplaySYNMAT;
end
    
    
