function ObjSel = ObjectSelectivity(layer)
    % Calculates the Object Selectivity similar to that in info.m
    % Can only be run after test(), because this uses EFRDATA
    % copyright E T Rolls, Oxford Centre for Computational Neuroscience
    
   
   global EFR EFRDATA NLAYERS NET_SIZE SQNET_SIZE N_FILES N_GROUPS N_VIEWS N_LOCS BESTCELLS NBESTCELLS ...
       NBESTCELLSINFORM NTRANSFORMS XY_VIEW XY_VIEW_TEST PARAMETER_LIST SYNMAT SYNMAT_CHANGE ...
       SYNMAT_CHANGE_GROUP LOGNUM FIXEDTRACE SPARSENESS BETA ETA LRNRATE NSYN SYNMATL1 SYNMATL2 SYNMATL3 ...
       SYNMATL4 VNLOGINDEX IMLIST IMLIST_TEST N_VIEWS_TEST FILTIM NSYNL1 Images base_dir image_dir ...
       FiltImSize SqFiltImSize Display ...
       filter_layer_1 filter_layer_2  filter_layer_3 filter_layer_4 SIGMOID LATERALINHIB;
 
    if layer < 1
        layer = 1
    elseif layer > 4
        layer = 4
    end
         
    % correlation matrix between different test images in the firing of the specified layer
    N_GROUPS_TEST = N_GROUPS; % Set this up thus for now
    Rates = zeros(SQNET_SIZE, N_GROUPS_TEST * N_VIEWS_TEST * N_LOCS);
    counter = 1;
    for group = 1 : N_GROUPS_TEST
        for view = 1 : N_VIEWS_TEST
            for loc = 1 : N_LOCS
                EFRtmp = EFRDATA(group,view,loc,layer,:,:); %object,view,loc,layer,R, C
                EFRtmp = reshape(EFRtmp, SQNET_SIZE, 1);
                Rates(:, counter) = EFRtmp;
                counter = counter + 1;
            end
        end
    end 
    CorMat = zeros(N_GROUPS_TEST * N_VIEWS_TEST * N_LOCS);
    for i = 1 : size(Rates, 2)
        for j = 1 : size(Rates, 2)
    %            distance(j,i) = norm(rates(i,:) - rates(j,:));
            %CorMat(j,i) = dot(Rates(:, i), Rates(:, j));
            R = corrcoef(Rates(:, i), Rates(:, j));
            CorMat(j,i) = R(1,2);
        end
    end
    figure(101)
    imagesc(CorMat);
    colormap(gray(256));
    title([' Correlation of firing for layer ', num2str(layer), ' between the transforms']);
    %title([' Correlation of firing for layer ', num2str(layer), ' between the transforms  min=', num2str(min(min(CorMat)))]);
    xlabel('Transform Number');
    ylabel('Transform Number');
    c = colorbar;
    ylabel(c, 'Correlation');
    colormap(gray(256));
    % min(min(CorMat))
    % max(max(CorMat))
    
    % Now calculate an object selectivity measure
    % i.e. how much the firing of the layer responds to all views of a given object
    % and to no views of other objects
    % A value of 1.0 indicates perfect object selectivity with complete transform invariance
    RespToObj = 0;
    RespToOtherObjs = 0;
    L = length(CorMat);
    NTransforms = N_VIEWS_TEST * N_LOCS; % number of transforms of each object
    for r = 1 : L % rows
        groupr = floor((r - 1) / NTransforms) + 1; % the group or object for this row
        for c = 1 : L % columns
            CorClipped = CorMat(r, c);
            if CorClipped < 0
                CorClipped = 0; % some correlations may be just < 0
            end
            groupc = floor((c - 1) / NTransforms) + 1; % the group or object for this column
            if groupr == groupc % if this is the same object
                RespToObj = RespToObj + CorClipped;
            else
                RespToOtherObjs = RespToOtherObjs + CorClipped;
            end
        end
    end
    RespToObj;
    RespToOtherObjs;
    ExpectedRespToObj = NTransforms * NTransforms * N_GROUPS; % This is what is expected if for each object the neurons respond to all views / transforms of the object
    ObjectSelectivityExpected = RespToObj / (ExpectedRespToObj + RespToOtherObjs); % 1.0 would be perfect performance
    fprintf('ObjectSelectivity = %4.2f\n',    ObjectSelectivityExpected);
    ObjSel = ObjectSelectivityExpected;
end

