function SetIMLIST(IMLIST, IMLIST_TEST, base_dir, Interpolation)
    % This is part of the VisNet software suite, and is called from VisNet7.m
    % It sets up the list of images to be used for training and testing
    % Edit base_dir to make it refer to wherever you have the views of each object on your computer
    % Windows uses '\', and Linux/Macs use '/'
    % Set ImageSet to 1 for a set of 3 simple bars each with as the images
    % Set ImageSet to 2 for a set of images from the Amsterdam Library of Images (ALOI) etc

    % IMLIST(:, 1) is a sequential numerical list of the filenames of the training images
    % IMLIST(:, 2) is a list that shows the object number for the image
    % Each Object has N_VIEWS images, each a different transform of the object. Make sure that N_VIEWS is set to the correct number in VisNet7b.m

    % IMLIST_TEST is a similar list used during testing.
    % IMLIST_TEST might contain intermediate views to those used for training; or it might be the same as IMLIST
    % N_VIEWS_TEST must also be set in to the number of views or transforms of each object provided here

    % Interpolation = 0; % 0 for IMLIST_TEST = IMLIST; 1 for using interpolated images for testing. 4th argument above
    
    
    global EFR EFRDATA NLAYERS NET_SIZE SQNET_SIZE N_FILES N_GROUPS N_VIEWS N_LOCS BESTCELLS NBESTCELLS ...
           NBESTCELLSINFORM NTRANSFORMS PARAMETER_LIST SYNMAT SYNMAT_CHANGE ...
           SYNMAT_CHANGE_GROUP LOGNUM FIXEDTRACE SPARSENESS BETA ETA LRNRATE NSYN SYNMATL1 SYNMATL2 SYNMATL3 ...
           SYNMATL4 VNLOGINDEX IMLIST IMLIST_TEST N_VIEWS_TEST FILTIM NSYNL1 Images base_dir image_dir ...
           FiltImSize SqFiltImSize Display ...
           filter_layer_1 filter_layer_2  filter_layer_3 filter_layer_4 SIGMOID LATERALINHIB TraceDisp DisplaySYNMATprevious

    ImageSet = 2; % 1 for bars each with 3 transforms; 2 for ALOI objects each with 9 views/transforms

    if ImageSet == 1
        % For the testbars
        base_dir = '..\imagedata\testbars256\'; % for Windows 10
        % base_dir = 'E:\Project\imagedata\testbars256\'; % for Windows 10
        N_GROUPS = 3; % There are only 3 testbar objects, so make sure here.
        N_VIEWS = 9; % Repeat some objects in the list as there are only 3 views, to allow the trace rule to work.
        N_VIEWS_TEST = 3; % Make sure this is set correctly for this set with only 3 views per object

        IMLIST = cell(N_GROUPS * N_VIEWS, 2);          % filename, group. 
        IMLIST{1 ,1} = 'v1';
        IMLIST{2 ,1} = 'v2';
        IMLIST{3 ,1} = 'v3';           % if we have fewer than about 9 transforms, we repeat some, to that each object is shown for about 9 or
                                       % more times to allow the trace rule to work
        IMLIST{4 ,1} = 'v1';
        IMLIST{5 ,1} = 'v2';
        IMLIST{6 ,1} = 'v3';
        IMLIST{7 ,1} = 'v1';
        IMLIST{8 ,1} = 'v2';
        IMLIST{9 ,1} = 'v3';
        IMLIST{10 ,1} = 'h1';
        IMLIST{11 ,1} = 'h2';
        IMLIST{12 ,1} = 'h3';
        IMLIST{13 ,1} = 'h1';
        IMLIST{14 ,1} = 'h2';
        IMLIST{15 ,1} = 'h3';
        IMLIST{16 ,1} = 'h1';
        IMLIST{17 ,1} = 'h2';
        IMLIST{18 ,1} = 'h3';
        IMLIST{19 ,1} = 'd1';
        IMLIST{20 ,1} = 'd2';
        IMLIST{21 ,1} = 'd3';
        IMLIST{22 ,1} = 'd1';
        IMLIST{23 ,1} = 'd2';
        IMLIST{24 ,1} = 'd3';
        IMLIST{25 ,1} = 'd1';
        IMLIST{26 ,1} = 'd2';
        IMLIST{27 ,1} = 'd3';
        for i = 1 : 9
            IMLIST{i, 2} = 1;
        end
        for i = 10 : 18
            IMLIST{i, 2} = 2;
        end
        for i = 19 : 27
            IMLIST{i, 2} = 3;
        end

        IMLIST_TEST = cell(N_GROUPS * N_VIEWS_TEST, 2);          % filename, group
        IMLIST_TEST{1 ,1} = 'v1';          % there are only 3 views here to test
        IMLIST_TEST{2 ,1} = 'v2';
        IMLIST_TEST{3 ,1} = 'v3';
        IMLIST_TEST{4 ,1} = 'h1';
        IMLIST_TEST{5 ,1} = 'h2';
        IMLIST_TEST{6 ,1} = 'h3';
        IMLIST_TEST{7 ,1} = 'd1';
        IMLIST_TEST{8 ,1} = 'd2';
        IMLIST_TEST{9 ,1} = 'd3';
        IMLIST_TEST{1 ,2} = 1;
        IMLIST_TEST{2 ,2} = 1;
        IMLIST_TEST{3 ,2} = 1;
        IMLIST_TEST{4 ,2} = 2;
        IMLIST_TEST{5 ,2} = 2;
        IMLIST_TEST{6 ,2} = 2;
        IMLIST_TEST{7 ,2} = 3;
        IMLIST_TEST{8 ,2} = 3;
        IMLIST_TEST{9 ,2} = 3;
        N_VIEWS_TEST = 3;    % number of transforms for testing
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    elseif ImageSet == 2
        % For the Amsterdam Library of Images objects
        base_dir = '..\imagedata\128image_9\'; % this has just the first 9 objects
        % base_dir = 'c:\imagedata\128image_copy\128image_copy\'; % this has just the first 9 objects
        %base_dir = 'c:\imagedata\128image_copy_new\128image_copy\'; % this has 25 objects
        %base_dir = 'c:\imagedata\128image_copy_50\128image_copy_50\'; % this has 50 objects
        %base_dir = 'C:\imagedata\128image_copy_50Both\128image_copy_50\'; % this has interpolated as well as training views
        % base_dir = 'E:\Project\imagedata\128image_copy_50\'; % this has 50 objects

        N_VIEWS = 9;
        N_VIEWS_TEST = 9; % Make sure this is set correctly for this set

        IMLIST = cell(N_GROUPS * N_VIEWS, 2);          % cell(filename, group) where group specifies the object number for that image
        IMLIST{1 ,1} = '32_r10';
        IMLIST{2 ,1} = '32_r50';
        IMLIST{3 ,1} = '32_r90';
        IMLIST{4 ,1} = '32_r130';
        IMLIST{5 ,1} = '32_r170';
        IMLIST{6 ,1} = '32_r210';
        IMLIST{7 ,1} = '32_r250';
        IMLIST{8 ,1} = '32_r290';
        IMLIST{9 ,1} = '32_r330';
        IMLIST{10 ,1} = '203_r10';
        IMLIST{11 ,1} = '203_r50';
        IMLIST{12 ,1} = '203_r90';
        IMLIST{13 ,1} = '203_r130';
        IMLIST{14 ,1} = '203_r170';
        IMLIST{15 ,1} = '203_r210';
        IMLIST{16 ,1} = '203_r250';
        IMLIST{17 ,1} = '203_r290';
        IMLIST{18 ,1} = '203_r330';
        IMLIST{19 ,1} = '364_r10';
        IMLIST{20 ,1} = '364_r50';
        IMLIST{21 ,1} = '364_r90';
        IMLIST{22 ,1} = '364_r130';
        IMLIST{23 ,1} = '364_r170';
        IMLIST{24 ,1} = '364_r210';
        IMLIST{25 ,1} = '364_r250';
        IMLIST{26 ,1} = '364_r290';
        IMLIST{27 ,1} = '364_r330';
        IMLIST{28 ,1} = '9_r10';
        IMLIST{29 ,1} = '9_r50';
        IMLIST{30 ,1} = '9_r90';
        IMLIST{31 ,1} = '9_r130';
        IMLIST{32 ,1} = '9_r170';
        IMLIST{33 ,1} = '9_r210';
        IMLIST{34 ,1} = '9_r250';
        IMLIST{35 ,1} = '9_r290';
        IMLIST{36 ,1} = '9_r330';
        IMLIST{37 ,1} = '10_r10';
        IMLIST{38 ,1} = '10_r50';
        IMLIST{39 ,1} = '10_r90';
        IMLIST{40 ,1} = '10_r130';
        IMLIST{41 ,1} = '10_r170';
        IMLIST{42 ,1} = '10_r210';
        IMLIST{43 ,1} = '10_r250';
        IMLIST{44 ,1} = '10_r290';
        IMLIST{45 ,1} = '10_r330';
        IMLIST{46 ,1} = '23_r10';
        IMLIST{47 ,1} = '23_r50';
        IMLIST{48 ,1} = '23_r90';
        IMLIST{49 ,1} = '23_r130';
        IMLIST{50 ,1} = '23_r170';
        IMLIST{51 ,1} = '23_r210';
        IMLIST{52 ,1} = '23_r250';
        IMLIST{53 ,1} = '23_r290';
        IMLIST{54 ,1} = '23_r330';
        IMLIST{55 ,1} = '443_r10';
        IMLIST{56 ,1} = '443_r50';
        IMLIST{57 ,1} = '443_r90';
        IMLIST{58 ,1} = '443_r130';
        IMLIST{59 ,1} = '443_r170';
        IMLIST{60 ,1} = '443_r210';
        IMLIST{61 ,1} = '443_r250';
        IMLIST{62 ,1} = '443_r290';
        IMLIST{63 ,1} = '443_r330';
        IMLIST{64 ,1} = '450_r10';
        IMLIST{65 ,1} = '450_r50';
        IMLIST{66 ,1} = '450_r90';
        IMLIST{67 ,1} = '450_r130';
        IMLIST{68 ,1} = '450_r170';
        IMLIST{69 ,1} = '450_r210';
        IMLIST{70 ,1} = '450_r250';
        IMLIST{71 ,1} = '450_r290';
        IMLIST{72 ,1} = '450_r330';
        IMLIST{73 ,1} = '500_r10';
        IMLIST{74 ,1} = '500_r50';
        IMLIST{75 ,1} = '500_r90';
        IMLIST{76 ,1} = '500_r130';
        IMLIST{77 ,1} = '500_r170';
        IMLIST{78 ,1} = '500_r210';
        IMLIST{79 ,1} = '500_r250';
        IMLIST{80 ,1} = '500_r290';
        IMLIST{81 ,1} = '500_r330';
        IMLIST{82 ,1} = '19_r10';
        IMLIST{83 ,1} = '19_r50';
        IMLIST{84 ,1} = '19_r90';
        IMLIST{85 ,1} = '19_r130';
        IMLIST{86 ,1} = '19_r170';
        IMLIST{87 ,1} = '19_r210';
        IMLIST{88 ,1} = '19_r250';
        IMLIST{89 ,1} = '19_r290';
        IMLIST{90 ,1} = '19_r330';
        IMLIST{91 ,1} = '20_r10';
        IMLIST{92, 1} = '20_r50';
        IMLIST{93 ,1} = '20_r90';
        IMLIST{94 ,1} = '20_r130';
        IMLIST{95 ,1} = '20_r170';
        IMLIST{96 ,1} = '20_r210';
        IMLIST{97 ,1} = '20_r250';
        IMLIST{98 ,1} = '20_r290';
        IMLIST{99 ,1} = '20_r330';
        IMLIST{100 ,1} = '21_r10';
        IMLIST{101, 1} = '21_r50';
        IMLIST{102 ,1} = '21_r90';
        IMLIST{103 ,1} = '21_r130';
        IMLIST{104 ,1} = '21_r170';
        IMLIST{105 ,1} = '21_r210';
        IMLIST{106 ,1} = '21_r250';
        IMLIST{107 ,1} = '21_r290';
        IMLIST{108 ,1} = '21_r330';
        IMLIST{109 ,1} = '28_r10';
        IMLIST{110, 1} = '28_r50';
        IMLIST{111 ,1} = '28_r90';
        IMLIST{112 ,1} = '28_r130';
        IMLIST{113 ,1} = '28_r170';
        IMLIST{114 ,1} = '28_r210';
        IMLIST{115 ,1} = '28_r250';
        IMLIST{116 ,1} = '28_r290';
        IMLIST{117 ,1} = '28_r330';
        IMLIST{118 ,1} = '36_r10';
        IMLIST{119, 1} = '36_r50';
        IMLIST{120 ,1} = '36_r90';
        IMLIST{121 ,1} = '36_r130';
        IMLIST{122 ,1} = '36_r170';
        IMLIST{123 ,1} = '36_r210';
        IMLIST{124 ,1} = '36_r250';
        IMLIST{125 ,1} = '36_r290';
        IMLIST{126 ,1} = '36_r330';
        IMLIST{127 ,1} = '38_r10';
        IMLIST{128, 1} = '38_r50';
        IMLIST{129 ,1} = '38_r90';
        IMLIST{130 ,1} = '38_r130';
        IMLIST{131 ,1} = '38_r170';
        IMLIST{132 ,1} = '38_r210';
        IMLIST{133 ,1} = '38_r250';
        IMLIST{134 ,1} = '38_r290';
        IMLIST{135 ,1} = '38_r330';
        IMLIST{136 ,1} = '51_r10';
        IMLIST{137, 1} = '51_r50';
        IMLIST{138 ,1} = '51_r90';
        IMLIST{139 ,1} = '51_r130';
        IMLIST{140 ,1} = '51_r170';
        IMLIST{141 ,1} = '51_r210';
        IMLIST{142 ,1} = '51_r250';
        IMLIST{143 ,1} = '51_r290';
        IMLIST{144 ,1} = '51_r330';
        IMLIST{145 ,1} = '60_r10';
        IMLIST{146, 1} = '60_r50';
        IMLIST{147 ,1} = '60_r90';
        IMLIST{148 ,1} = '60_r130';
        IMLIST{149 ,1} = '60_r170';
        IMLIST{150 ,1} = '60_r210';
        IMLIST{151 ,1} = '60_r250';
        IMLIST{152 ,1} = '60_r290';
        IMLIST{153 ,1} = '60_r330';
        IMLIST{154 ,1} = '68_r10';
        IMLIST{155, 1} = '68_r50';
        IMLIST{156 ,1} = '68_r90';
        IMLIST{157 ,1} = '68_r130';
        IMLIST{158 ,1} = '68_r170';
        IMLIST{159 ,1} = '68_r210';
        IMLIST{160 ,1} = '68_r250';
        IMLIST{161 ,1} = '68_r290';
        IMLIST{162 ,1} = '68_r330';
        IMLIST{163 ,1} = '100_r10';
        IMLIST{164, 1} = '100_r50';
        IMLIST{165 ,1} = '100_r90';
        IMLIST{166 ,1} = '100_r130';
        IMLIST{167 ,1} = '100_r170';
        IMLIST{168 ,1} = '100_r210';
        IMLIST{169 ,1} = '100_r250';
        IMLIST{170 ,1} = '100_r290';
        IMLIST{171 ,1} = '100_r330';
        IMLIST{172 ,1} = '1_r10';
        IMLIST{173, 1} = '1_r50';
        IMLIST{174 ,1} = '1_r90';
        IMLIST{175 ,1} = '1_r130';
        IMLIST{176 ,1} = '1_r170';
        IMLIST{177 ,1} = '1_r210';
        IMLIST{178 ,1} = '1_r250';
        IMLIST{179 ,1} = '1_r290';
        IMLIST{180 ,1} = '1_r330';
        IMLIST{181 ,1} = '2_r10';
        IMLIST{182, 1} = '2_r50';
        IMLIST{183 ,1} = '2_r90';
        IMLIST{184 ,1} = '2_r130';
        IMLIST{185 ,1} = '2_r170';
        IMLIST{186 ,1} = '2_r210';
        IMLIST{187 ,1} = '2_r250';
        IMLIST{188 ,1} = '2_r290';
        IMLIST{189 ,1} = '2_r330';
        IMLIST{190 ,1} = '3_r10';
        IMLIST{191, 1} = '3_r50';
        IMLIST{192 ,1} = '3_r90';
        IMLIST{193 ,1} = '3_r130';
        IMLIST{194 ,1} = '3_r170';
        IMLIST{195 ,1} = '3_r210';
        IMLIST{196 ,1} = '3_r250';
        IMLIST{197 ,1} = '3_r290';
        IMLIST{198 ,1} = '3_r330';
        IMLIST{199 ,1} = '6_r10';
        IMLIST{200, 1} = '6_r50';
        IMLIST{201 ,1} = '6_r90';
        IMLIST{202 ,1} = '6_r130';
        IMLIST{203 ,1} = '6_r170';
        IMLIST{204 ,1} = '6_r210';
        IMLIST{205 ,1} = '6_r250';
        IMLIST{206 ,1} = '6_r290';
        IMLIST{207 ,1} = '6_r330';
        IMLIST{208 ,1} = '7_r10';
        IMLIST{209, 1} = '7_r50';
        IMLIST{210 ,1} = '7_r90';
        IMLIST{211 ,1} = '7_r130';
        IMLIST{212 ,1} = '7_r170';
        IMLIST{213 ,1} = '7_r210';
        IMLIST{214 ,1} = '7_r250';
        IMLIST{215 ,1} = '7_r290';
        IMLIST{216 ,1} = '7_r330';
        IMLIST{217 ,1} = '13_r10';
        IMLIST{218, 1} = '13_r50';
        IMLIST{219 ,1} = '13_r90';
        IMLIST{220 ,1} = '13_r130';
        IMLIST{221 ,1} = '13_r170';
        IMLIST{222 ,1} = '13_r210';
        IMLIST{223 ,1} = '13_r250';
        IMLIST{224 ,1} = '13_r290';
        IMLIST{225 ,1} = '13_r330';
        IMLIST{226 ,1} = '62_r10'; % Object 26
        IMLIST{227 ,1} = '62_r50';
        IMLIST{228 ,1} = '62_r90';
        IMLIST{229 ,1} = '62_r130';
        IMLIST{230 ,1} = '62_r170';
        IMLIST{231 ,1} = '62_r210';
        IMLIST{232 ,1} = '62_r250';
        IMLIST{233 ,1} = '62_r290';
        IMLIST{234 ,1} = '62_r330';
        IMLIST{235 ,1} = '79_r10';
        IMLIST{236 ,1} = '79_r50';
        IMLIST{237 ,1} = '79_r90';
        IMLIST{238 ,1} = '79_r130';
        IMLIST{239 ,1} = '79_r170';
        IMLIST{240 ,1} = '79_r210';
        IMLIST{241 ,1} = '79_r250';
        IMLIST{242 ,1} = '79_r290';
        IMLIST{243 ,1} = '79_r330';
        IMLIST{244 ,1} = '127_r10';
        IMLIST{245 ,1} = '127_r50';
        IMLIST{246 ,1} = '127_r90';
        IMLIST{247 ,1} = '127_r130';
        IMLIST{248 ,1} = '127_r170';
        IMLIST{249 ,1} = '127_r210';
        IMLIST{250 ,1} = '127_r250';
        IMLIST{251 ,1} = '127_r290';
        IMLIST{252 ,1} = '127_r330';
        IMLIST{253 ,1} = '151_r10';
        IMLIST{254 ,1} = '151_r50';
        IMLIST{255 ,1} = '151_r90';
        IMLIST{256 ,1} = '151_r130';
        IMLIST{257 ,1} = '151_r170';
        IMLIST{258 ,1} = '151_r210';
        IMLIST{259 ,1} = '151_r250';
        IMLIST{260 ,1} = '151_r290';
        IMLIST{261 ,1} = '151_r330';
        IMLIST{262 ,1} = '161_r10';
        IMLIST{263 ,1} = '161_r50';
        IMLIST{264 ,1} = '161_r90';
        IMLIST{265 ,1} = '161_r130';
        IMLIST{266 ,1} = '161_r170';
        IMLIST{267 ,1} = '161_r210';
        IMLIST{268 ,1} = '161_r250';
        IMLIST{269 ,1} = '161_r290';
        IMLIST{270 ,1} = '161_r330';
        IMLIST{271 ,1} = '175_r10';
        IMLIST{272 ,1} = '175_r50';
        IMLIST{273 ,1} = '175_r90';
        IMLIST{274 ,1} = '175_r130';
        IMLIST{275 ,1} = '175_r170';
        IMLIST{276 ,1} = '175_r210';
        IMLIST{277 ,1} = '175_r250';
        IMLIST{278 ,1} = '175_r290';
        IMLIST{279 ,1} = '175_r330';
        IMLIST{280 ,1} = '182_r10';
        IMLIST{281 ,1} = '182_r50';
        IMLIST{282 ,1} = '182_r90';
        IMLIST{283 ,1} = '182_r130';
        IMLIST{284 ,1} = '182_r170';
        IMLIST{285 ,1} = '182_r210';
        IMLIST{286 ,1} = '182_r250';
        IMLIST{287 ,1} = '182_r290';
        IMLIST{288 ,1} = '182_r330';
        IMLIST{289 ,1} = '202_r10';
        IMLIST{290 ,1} = '202_r50';
        IMLIST{291 ,1} = '202_r90';
        IMLIST{292 ,1} = '202_r130';
        IMLIST{293 ,1} = '202_r170';
        IMLIST{294 ,1} = '202_r210';
        IMLIST{295 ,1} = '202_r250';
        IMLIST{296 ,1} = '202_r290';
        IMLIST{297 ,1} = '202_r330';
        IMLIST{298 ,1} = '209_r10';
        IMLIST{299 ,1} = '209_r50';
        IMLIST{300 ,1} = '209_r90';
        IMLIST{301 ,1} = '209_r130';
        IMLIST{302 ,1} = '209_r170';
        IMLIST{303 ,1} = '209_r210';
        IMLIST{304 ,1} = '209_r250';
        IMLIST{305 ,1} = '209_r290';
        IMLIST{306 ,1} = '209_r330';
        IMLIST{307 ,1} = '248_r10';
        IMLIST{308 ,1} = '248_r50';
        IMLIST{309 ,1} = '248_r90';
        IMLIST{310 ,1} = '248_r130';
        IMLIST{311 ,1} = '248_r170';
        IMLIST{312 ,1} = '248_r210';
        IMLIST{313 ,1} = '248_r250';
        IMLIST{314 ,1} = '248_r290';
        IMLIST{315 ,1} = '248_r330';
        IMLIST{316 ,1} = '267_r10';
        IMLIST{317, 1} = '267_r50';
        IMLIST{318 ,1} = '267_r90';
        IMLIST{319 ,1} = '267_r130';
        IMLIST{320 ,1} = '267_r170';
        IMLIST{321 ,1} = '267_r210';
        IMLIST{322 ,1} = '267_r250';
        IMLIST{323 ,1} = '267_r290';
        IMLIST{324 ,1} = '267_r330';
        IMLIST{325 ,1} = '282_r10';
        IMLIST{326, 1} = '282_r50';
        IMLIST{327 ,1} = '282_r90';
        IMLIST{328 ,1} = '282_r130';
        IMLIST{329 ,1} = '282_r170';
        IMLIST{330 ,1} = '282_r210';
        IMLIST{331 ,1} = '282_r250';
        IMLIST{332 ,1} = '282_r290';
        IMLIST{333 ,1} = '282_r330';
        IMLIST{334 ,1} = '307_r10';
        IMLIST{335, 1} = '307_r50';
        IMLIST{336 ,1} = '307_r90';
        IMLIST{337 ,1} = '307_r130';
        IMLIST{338 ,1} = '307_r170';
        IMLIST{339 ,1} = '307_r210';
        IMLIST{340 ,1} = '307_r250';
        IMLIST{341 ,1} = '307_r290';
        IMLIST{342 ,1} = '307_r330';
        IMLIST{343 ,1} = '313_r10';
        IMLIST{344, 1} = '313_r50';
        IMLIST{345 ,1} = '313_r90';
        IMLIST{346 ,1} = '313_r130';
        IMLIST{347 ,1} = '313_r170';
        IMLIST{348 ,1} = '313_r210';
        IMLIST{349 ,1} = '313_r250';
        IMLIST{350 ,1} = '313_r290';
        IMLIST{351 ,1} = '313_r330';
        IMLIST{352 ,1} = '357_r10';
        IMLIST{353, 1} = '357_r50';
        IMLIST{354 ,1} = '357_r90';
        IMLIST{355 ,1} = '357_r130';
        IMLIST{356 ,1} = '357_r170';
        IMLIST{357 ,1} = '357_r210';
        IMLIST{358 ,1} = '357_r250';
        IMLIST{359 ,1} = '357_r290';
        IMLIST{360 ,1} = '357_r330';
        IMLIST{361 ,1} = '381_r10';
        IMLIST{362, 1} = '381_r50';
        IMLIST{363 ,1} = '381_r90';
        IMLIST{364 ,1} = '381_r130';
        IMLIST{365 ,1} = '381_r170';
        IMLIST{366 ,1} = '381_r210';
        IMLIST{367 ,1} = '381_r250';
        IMLIST{368 ,1} = '381_r290';
        IMLIST{369 ,1} = '381_r330';
        IMLIST{370 ,1} = '409_r10';
        IMLIST{371, 1} = '409_r50';
        IMLIST{372 ,1} = '409_r90';
        IMLIST{373 ,1} = '409_r130';
        IMLIST{374 ,1} = '409_r170';
        IMLIST{375 ,1} = '409_r210';
        IMLIST{376 ,1} = '409_r250';
        IMLIST{377 ,1} = '409_r290';
        IMLIST{378 ,1} = '409_r330';
        IMLIST{379 ,1} = '503_r10';
        IMLIST{380, 1} = '503_r50';
        IMLIST{381 ,1} = '503_r90';
        IMLIST{382 ,1} = '503_r130';
        IMLIST{383 ,1} = '503_r170';
        IMLIST{384 ,1} = '503_r210';
        IMLIST{385 ,1} = '503_r250';
        IMLIST{386 ,1} = '503_r290';
        IMLIST{387 ,1} = '503_r330';
        IMLIST{388 ,1} = '537_r10';
        IMLIST{389, 1} = '537_r50';
        IMLIST{390 ,1} = '537_r90';
        IMLIST{391 ,1} = '537_r130';
        IMLIST{392 ,1} = '537_r170';
        IMLIST{393 ,1} = '537_r210';
        IMLIST{394 ,1} = '537_r250';
        IMLIST{395 ,1} = '537_r290';
        IMLIST{396 ,1} = '537_r330';
        IMLIST{397 ,1} = '584_r10';
        IMLIST{398, 1} = '584_r50';
        IMLIST{399 ,1} = '584_r90';
        IMLIST{400 ,1} = '584_r130';
        IMLIST{401 ,1} = '584_r170';
        IMLIST{402 ,1} = '584_r210';
        IMLIST{403 ,1} = '584_r250';
        IMLIST{404 ,1} = '584_r290';
        IMLIST{405 ,1} = '584_r330';
        IMLIST{406 ,1} = '610_r10';
        IMLIST{407, 1} = '610_r50';
        IMLIST{408 ,1} = '610_r90';
        IMLIST{409 ,1} = '610_r130';
        IMLIST{410 ,1} = '610_r170';
        IMLIST{411 ,1} = '610_r210';
        IMLIST{412 ,1} = '610_r250';
        IMLIST{413 ,1} = '610_r290';
        IMLIST{414 ,1} = '610_r330';
        IMLIST{415 ,1} = '675_r10';
        IMLIST{416, 1} = '675_r50';
        IMLIST{417 ,1} = '675_r90';
        IMLIST{418 ,1} = '675_r130';
        IMLIST{419 ,1} = '675_r170';
        IMLIST{420 ,1} = '675_r210';
        IMLIST{421 ,1} = '675_r250';
        IMLIST{422 ,1} = '675_r290';
        IMLIST{423 ,1} = '675_r330';
        IMLIST{424 ,1} = '893_r10';
        IMLIST{425, 1} = '893_r50';
        IMLIST{426 ,1} = '893_r90';
        IMLIST{427 ,1} = '893_r130';
        IMLIST{428 ,1} = '893_r170';
        IMLIST{429 ,1} = '893_r210';
        IMLIST{430 ,1} = '893_r250';
        IMLIST{431 ,1} = '893_r290';
        IMLIST{432 ,1} = '893_r330';
        IMLIST{433 ,1} = '910_r10';
        IMLIST{434, 1} = '910_r50';
        IMLIST{435 ,1} = '910_r90';
        IMLIST{436 ,1} = '910_r130';
        IMLIST{437 ,1} = '910_r170';
        IMLIST{438 ,1} = '910_r210';
        IMLIST{439 ,1} = '910_r250';
        IMLIST{440 ,1} = '910_r290';
        IMLIST{441 ,1} = '910_r330';
        IMLIST{442 ,1} = '942_r10';
        IMLIST{443, 1} = '942_r50';
        IMLIST{444 ,1} = '942_r90';
        IMLIST{445 ,1} = '942_r130';
        IMLIST{446 ,1} = '942_r170';
        IMLIST{447 ,1} = '942_r210';
        IMLIST{448 ,1} = '942_r250';
        IMLIST{449 ,1} = '942_r290';
        IMLIST{450 ,1} = '942_r330';

        for i = 1 : length(IMLIST(:,1))
            IMLIST{i, 2} = floor((i - 1) / N_VIEWS) + 1; % Dimension 2 holds the object number (starting at 1) corersponding to each view
        end

        if Interpolation == 0 % In this condition, IMLIST_TEST = IMLIST
            IMLIST_TEST = IMLIST;

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        else % if Interpolation == 1  use interpolated images for testing 

            IMLIST_TEST = cell(N_GROUPS * N_VIEWS, 2);          % filename, group
            %base_dir = 'c:\imagedata\128image_copy_50_interp\128image_copy_50_interp\'; % this has 50 objects

            IMLIST_TEST{1 ,1} = '32_r30';
            IMLIST_TEST{2 ,1} = '32_r70';
            IMLIST_TEST{3 ,1} = '32_r110';
            IMLIST_TEST{4 ,1} = '32_r150';
            IMLIST_TEST{5 ,1} = '32_r190';
            IMLIST_TEST{6 ,1} = '32_r230';
            IMLIST_TEST{7 ,1} = '32_r270';
            IMLIST_TEST{8 ,1} = '32_r310';
            IMLIST_TEST{9 ,1} = '32_r350';
            IMLIST_TEST{10 ,1} = '203_r30';
            IMLIST_TEST{11 ,1} = '203_r70';
            IMLIST_TEST{12 ,1} = '203_r110';
            IMLIST_TEST{13 ,1} = '203_r150';
            IMLIST_TEST{14 ,1} = '203_r190';
            IMLIST_TEST{15 ,1} = '203_r230';
            IMLIST_TEST{16 ,1} = '203_r270';
            IMLIST_TEST{17 ,1} = '203_r310';
            IMLIST_TEST{18 ,1} = '203_r350';
            IMLIST_TEST{19 ,1} = '364_r30';
            IMLIST_TEST{20 ,1} = '364_r70';
            IMLIST_TEST{21 ,1} = '364_r110';
            IMLIST_TEST{22 ,1} = '364_r150';
            IMLIST_TEST{23 ,1} = '364_r190';
            IMLIST_TEST{24 ,1} = '364_r230';
            IMLIST_TEST{25 ,1} = '364_r270';
            IMLIST_TEST{26 ,1} = '364_r310';
            IMLIST_TEST{27 ,1} = '364_r350';
            IMLIST_TEST{28 ,1} = '9_r30';
            IMLIST_TEST{29 ,1} = '9_r70';
            IMLIST_TEST{30 ,1} = '9_r110';
            IMLIST_TEST{31 ,1} = '9_r150';
            IMLIST_TEST{32 ,1} = '9_r190';
            IMLIST_TEST{33 ,1} = '9_r230';
            IMLIST_TEST{34 ,1} = '9_r270';
            IMLIST_TEST{35 ,1} = '9_r310';
            IMLIST_TEST{36 ,1} = '9_r350';
            IMLIST_TEST{37 ,1} = '10_r30';
            IMLIST_TEST{38 ,1} = '10_r70';
            IMLIST_TEST{39 ,1} = '10_r110';
            IMLIST_TEST{40 ,1} = '10_r150';
            IMLIST_TEST{41 ,1} = '10_r190';
            IMLIST_TEST{42 ,1} = '10_r230';
            IMLIST_TEST{43 ,1} = '10_r270';
            IMLIST_TEST{44 ,1} = '10_r310';
            IMLIST_TEST{45 ,1} = '10_r350';
            IMLIST_TEST{46 ,1} = '23_r30';
            IMLIST_TEST{47 ,1} = '23_r70';
            IMLIST_TEST{48 ,1} = '23_r110';
            IMLIST_TEST{49 ,1} = '23_r150';
            IMLIST_TEST{50 ,1} = '23_r190';
            IMLIST_TEST{51 ,1} = '23_r230';
            IMLIST_TEST{52 ,1} = '23_r270';
            IMLIST_TEST{53 ,1} = '23_r310';
            IMLIST_TEST{54 ,1} = '23_r350';
            IMLIST_TEST{55 ,1} = '443_r30';
            IMLIST_TEST{56 ,1} = '443_r70';
            IMLIST_TEST{57 ,1} = '443_r110';
            IMLIST_TEST{58 ,1} = '443_r150';
            IMLIST_TEST{59 ,1} = '443_r190';
            IMLIST_TEST{60 ,1} = '443_r230';
            IMLIST_TEST{61 ,1} = '443_r270';
            IMLIST_TEST{62 ,1} = '443_r310';
            IMLIST_TEST{63 ,1} = '443_r350';
            IMLIST_TEST{64 ,1} = '450_r30';
            IMLIST_TEST{65 ,1} = '450_r70';
            IMLIST_TEST{66 ,1} = '450_r110';
            IMLIST_TEST{67 ,1} = '450_r150';
            IMLIST_TEST{68 ,1} = '450_r190';
            IMLIST_TEST{69 ,1} = '450_r230';
            IMLIST_TEST{70 ,1} = '450_r270';
            IMLIST_TEST{71 ,1} = '450_r310';
            IMLIST_TEST{72 ,1} = '450_r350';
            IMLIST_TEST{73 ,1} = '500_r30';
            IMLIST_TEST{74 ,1} = '500_r70';
            IMLIST_TEST{75 ,1} = '500_r110';
            IMLIST_TEST{76 ,1} = '500_r150';
            IMLIST_TEST{77 ,1} = '500_r190';
            IMLIST_TEST{78 ,1} = '500_r230';
            IMLIST_TEST{79 ,1} = '500_r270';
            IMLIST_TEST{80 ,1} = '500_r310';
            IMLIST_TEST{81 ,1} = '500_r350';
            IMLIST_TEST{82 ,1} = '19_r30';
            IMLIST_TEST{83 ,1} = '19_r70';
            IMLIST_TEST{84 ,1} = '19_r110';
            IMLIST_TEST{85 ,1} = '19_r150';
            IMLIST_TEST{86 ,1} = '19_r190';
            IMLIST_TEST{87 ,1} = '19_r230';
            IMLIST_TEST{88 ,1} = '19_r270';
            IMLIST_TEST{89 ,1} = '19_r310';
            IMLIST_TEST{90 ,1} = '19_r350';
            IMLIST_TEST{91 ,1} = '20_r30';
            IMLIST_TEST{92, 1} = '20_r70';
            IMLIST_TEST{93 ,1} = '20_r110';
            IMLIST_TEST{94 ,1} = '20_r150';
            IMLIST_TEST{95 ,1} = '20_r190';
            IMLIST_TEST{96 ,1} = '20_r230';
            IMLIST_TEST{97 ,1} = '20_r270';
            IMLIST_TEST{98 ,1} = '20_r310';
            IMLIST_TEST{99 ,1} = '20_r350';
            IMLIST_TEST{100 ,1} = '21_r30';
            IMLIST_TEST{101, 1} = '21_r70';
            IMLIST_TEST{102 ,1} = '21_r110';
            IMLIST_TEST{103 ,1} = '21_r150';
            IMLIST_TEST{104 ,1} = '21_r190';
            IMLIST_TEST{105 ,1} = '21_r230';
            IMLIST_TEST{106 ,1} = '21_r270';
            IMLIST_TEST{107 ,1} = '21_r310';
            IMLIST_TEST{108 ,1} = '21_r350';
            IMLIST_TEST{109 ,1} = '28_r30';
            IMLIST_TEST{110, 1} = '28_r70';
            IMLIST_TEST{111 ,1} = '28_r110';
            IMLIST_TEST{112 ,1} = '28_r150';
            IMLIST_TEST{113 ,1} = '28_r190';
            IMLIST_TEST{114 ,1} = '28_r230';
            IMLIST_TEST{115 ,1} = '28_r270';
            IMLIST_TEST{116 ,1} = '28_r310';
            IMLIST_TEST{117 ,1} = '28_r350';
            IMLIST_TEST{118 ,1} = '36_r30';
            IMLIST_TEST{119, 1} = '36_r70';
            IMLIST_TEST{120 ,1} = '36_r110';
            IMLIST_TEST{121 ,1} = '36_r150';
            IMLIST_TEST{122 ,1} = '36_r190';
            IMLIST_TEST{123 ,1} = '36_r230';
            IMLIST_TEST{124 ,1} = '36_r270';
            IMLIST_TEST{125 ,1} = '36_r310';
            IMLIST_TEST{126 ,1} = '36_r350';
            IMLIST_TEST{127 ,1} = '38_r30';
            IMLIST_TEST{128, 1} = '38_r70';
            IMLIST_TEST{129 ,1} = '38_r110';
            IMLIST_TEST{130 ,1} = '38_r150';
            IMLIST_TEST{131 ,1} = '38_r190';
            IMLIST_TEST{132 ,1} = '38_r230';
            IMLIST_TEST{133 ,1} = '38_r270';
            IMLIST_TEST{134 ,1} = '38_r310';
            IMLIST_TEST{135 ,1} = '38_r350';
            IMLIST_TEST{136 ,1} = '51_r30';
            IMLIST_TEST{137, 1} = '51_r70';
            IMLIST_TEST{138 ,1} = '51_r110';
            IMLIST_TEST{139 ,1} = '51_r150';
            IMLIST_TEST{140 ,1} = '51_r190';
            IMLIST_TEST{141 ,1} = '51_r230';
            IMLIST_TEST{142 ,1} = '51_r270';
            IMLIST_TEST{143 ,1} = '51_r310';
            IMLIST_TEST{144 ,1} = '51_r350';
            IMLIST_TEST{145 ,1} = '60_r30';
            IMLIST_TEST{146, 1} = '60_r70';
            IMLIST_TEST{147 ,1} = '60_r110';
            IMLIST_TEST{148 ,1} = '60_r150';
            IMLIST_TEST{149 ,1} = '60_r190';
            IMLIST_TEST{150 ,1} = '60_r230';
            IMLIST_TEST{151 ,1} = '60_r270';
            IMLIST_TEST{152 ,1} = '60_r310';
            IMLIST_TEST{153 ,1} = '60_r350';
            IMLIST_TEST{154 ,1} = '68_r30';
            IMLIST_TEST{155, 1} = '68_r70';
            IMLIST_TEST{156 ,1} = '68_r110';
            IMLIST_TEST{157 ,1} = '68_r150';
            IMLIST_TEST{158 ,1} = '68_r190';
            IMLIST_TEST{159 ,1} = '68_r230';
            IMLIST_TEST{160 ,1} = '68_r270';
            IMLIST_TEST{161 ,1} = '68_r310';
            IMLIST_TEST{162 ,1} = '68_r350';
            IMLIST_TEST{163 ,1} = '100_r30';
            IMLIST_TEST{164, 1} = '100_r70';
            IMLIST_TEST{165 ,1} = '100_r110';
            IMLIST_TEST{166 ,1} = '100_r150';
            IMLIST_TEST{167 ,1} = '100_r190';
            IMLIST_TEST{168 ,1} = '100_r230';
            IMLIST_TEST{169 ,1} = '100_r270';
            IMLIST_TEST{170 ,1} = '100_r310';
            IMLIST_TEST{171 ,1} = '100_r350';
            IMLIST_TEST{172 ,1} = '1_r30';
            IMLIST_TEST{173, 1} = '1_r70';
            IMLIST_TEST{174 ,1} = '1_r110';
            IMLIST_TEST{175 ,1} = '1_r150';
            IMLIST_TEST{176 ,1} = '1_r190';
            IMLIST_TEST{177 ,1} = '1_r230';
            IMLIST_TEST{178 ,1} = '1_r270';
            IMLIST_TEST{179 ,1} = '1_r310';
            IMLIST_TEST{180 ,1} = '1_r350';
            IMLIST_TEST{181 ,1} = '2_r30';
            IMLIST_TEST{182, 1} = '2_r70';
            IMLIST_TEST{183 ,1} = '2_r110';
            IMLIST_TEST{184 ,1} = '2_r150';
            IMLIST_TEST{185 ,1} = '2_r190';
            IMLIST_TEST{186 ,1} = '2_r230';
            IMLIST_TEST{187 ,1} = '2_r270';
            IMLIST_TEST{188 ,1} = '2_r310';
            IMLIST_TEST{189 ,1} = '2_r350';
            IMLIST_TEST{190 ,1} = '3_r30';
            IMLIST_TEST{191, 1} = '3_r70';
            IMLIST_TEST{192 ,1} = '3_r110';
            IMLIST_TEST{193 ,1} = '3_r150';
            IMLIST_TEST{194 ,1} = '3_r190';
            IMLIST_TEST{195 ,1} = '3_r230';
            IMLIST_TEST{196 ,1} = '3_r270';
            IMLIST_TEST{197 ,1} = '3_r310';
            IMLIST_TEST{198 ,1} = '3_r350';
            IMLIST_TEST{199 ,1} = '6_r30';
            IMLIST_TEST{200, 1} = '6_r70';
            IMLIST_TEST{201 ,1} = '6_r110';
            IMLIST_TEST{202 ,1} = '6_r150';
            IMLIST_TEST{203 ,1} = '6_r190';
            IMLIST_TEST{204 ,1} = '6_r230';
            IMLIST_TEST{205 ,1} = '6_r270';
            IMLIST_TEST{206 ,1} = '6_r310';
            IMLIST_TEST{207 ,1} = '6_r350';
            IMLIST_TEST{208 ,1} = '7_r30';
            IMLIST_TEST{209, 1} = '7_r70';
            IMLIST_TEST{210 ,1} = '7_r110';
            IMLIST_TEST{211 ,1} = '7_r150';
            IMLIST_TEST{212 ,1} = '7_r190';
            IMLIST_TEST{213 ,1} = '7_r230';
            IMLIST_TEST{214 ,1} = '7_r270';
            IMLIST_TEST{215 ,1} = '7_r310';
            IMLIST_TEST{216 ,1} = '7_r350';
            IMLIST_TEST{217 ,1} = '13_r30';
            IMLIST_TEST{218, 1} = '13_r70';
            IMLIST_TEST{219 ,1} = '13_r110';
            IMLIST_TEST{220 ,1} = '13_r150';
            IMLIST_TEST{221 ,1} = '13_r190';
            IMLIST_TEST{222 ,1} = '13_r230';
            IMLIST_TEST{223 ,1} = '13_r270';
            IMLIST_TEST{224 ,1} = '13_r310';
            IMLIST_TEST{225 ,1} = '13_r350';
            IMLIST_TEST{226 ,1} = '62_r30';
            IMLIST_TEST{227 ,1} = '62_r70';
            IMLIST_TEST{228 ,1} = '62_r110';
            IMLIST_TEST{229 ,1} = '62_r150';
            IMLIST_TEST{230 ,1} = '62_r190';
            IMLIST_TEST{231 ,1} = '62_r230';
            IMLIST_TEST{232 ,1} = '62_r270';
            IMLIST_TEST{233 ,1} = '62_r310';
            IMLIST_TEST{234 ,1} = '62_r350';
            IMLIST_TEST{235 ,1} = '79_r30';
            IMLIST_TEST{236 ,1} = '79_r70';
            IMLIST_TEST{237 ,1} = '79_r110';
            IMLIST_TEST{238 ,1} = '79_r150';
            IMLIST_TEST{239 ,1} = '79_r190';
            IMLIST_TEST{240 ,1} = '79_r230';
            IMLIST_TEST{241 ,1} = '79_r270';
            IMLIST_TEST{242 ,1} = '79_r310';
            IMLIST_TEST{243 ,1} = '79_r350';
            IMLIST_TEST{244 ,1} = '127_r30';
            IMLIST_TEST{245 ,1} = '127_r70';
            IMLIST_TEST{246 ,1} = '127_r110';
            IMLIST_TEST{247 ,1} = '127_r150';
            IMLIST_TEST{248 ,1} = '127_r190';
            IMLIST_TEST{249 ,1} = '127_r230';
            IMLIST_TEST{250 ,1} = '127_r270';
            IMLIST_TEST{251 ,1} = '127_r310';
            IMLIST_TEST{252 ,1} = '127_r350';
            IMLIST_TEST{253 ,1} = '151_r30';
            IMLIST_TEST{254 ,1} = '151_r70';
            IMLIST_TEST{255 ,1} = '151_r110';
            IMLIST_TEST{256 ,1} = '151_r150';
            IMLIST_TEST{257 ,1} = '151_r190';
            IMLIST_TEST{258 ,1} = '151_r230';
            IMLIST_TEST{259 ,1} = '151_r270';
            IMLIST_TEST{260 ,1} = '151_r310';
            IMLIST_TEST{261 ,1} = '151_r350';
            IMLIST_TEST{262 ,1} = '161_r30';
            IMLIST_TEST{263 ,1} = '161_r70';
            IMLIST_TEST{264 ,1} = '161_r110';
            IMLIST_TEST{265 ,1} = '161_r150';
            IMLIST_TEST{266 ,1} = '161_r190';
            IMLIST_TEST{267 ,1} = '161_r230';
            IMLIST_TEST{268 ,1} = '161_r270';
            IMLIST_TEST{269 ,1} = '161_r310';
            IMLIST_TEST{270 ,1} = '161_r350';
            IMLIST_TEST{271 ,1} = '175_r30';
            IMLIST_TEST{272 ,1} = '175_r70';
            IMLIST_TEST{273 ,1} = '175_r110';
            IMLIST_TEST{274 ,1} = '175_r150';
            IMLIST_TEST{275 ,1} = '175_r190';
            IMLIST_TEST{276 ,1} = '175_r230';
            IMLIST_TEST{277 ,1} = '175_r270';
            IMLIST_TEST{278 ,1} = '175_r310';
            IMLIST_TEST{279 ,1} = '175_r350';
            IMLIST_TEST{280 ,1} = '182_r30';
            IMLIST_TEST{281 ,1} = '182_r70';
            IMLIST_TEST{282 ,1} = '182_r110';
            IMLIST_TEST{283 ,1} = '182_r150';
            IMLIST_TEST{284 ,1} = '182_r190';
            IMLIST_TEST{285 ,1} = '182_r230';
            IMLIST_TEST{286 ,1} = '182_r270';
            IMLIST_TEST{287 ,1} = '182_r310';
            IMLIST_TEST{288 ,1} = '182_r350';
            IMLIST_TEST{289 ,1} = '202_r30';
            IMLIST_TEST{290 ,1} = '202_r70';
            IMLIST_TEST{291 ,1} = '202_r110';
            IMLIST_TEST{292 ,1} = '202_r150';
            IMLIST_TEST{293 ,1} = '202_r190';
            IMLIST_TEST{294 ,1} = '202_r230';
            IMLIST_TEST{295 ,1} = '202_r270';
            IMLIST_TEST{296 ,1} = '202_r310';
            IMLIST_TEST{297 ,1} = '202_r350';
            IMLIST_TEST{298 ,1} = '209_r30';
            IMLIST_TEST{299 ,1} = '209_r70';
            IMLIST_TEST{300 ,1} = '209_r110';
            IMLIST_TEST{301 ,1} = '209_r150';
            IMLIST_TEST{302 ,1} = '209_r190';
            IMLIST_TEST{303 ,1} = '209_r230';
            IMLIST_TEST{304 ,1} = '209_r270';
            IMLIST_TEST{305 ,1} = '209_r310';
            IMLIST_TEST{306 ,1} = '209_r350';
            IMLIST_TEST{307 ,1} = '248_r30';
            IMLIST_TEST{308 ,1} = '248_r70';
            IMLIST_TEST{309 ,1} = '248_r110';
            IMLIST_TEST{310 ,1} = '248_r150';
            IMLIST_TEST{311 ,1} = '248_r190';
            IMLIST_TEST{312 ,1} = '248_r230';
            IMLIST_TEST{313 ,1} = '248_r270';
            IMLIST_TEST{314 ,1} = '248_r310';
            IMLIST_TEST{315 ,1} = '248_r350';
            IMLIST_TEST{316 ,1} = '267_r30';
            IMLIST_TEST{317, 1} = '267_r70';
            IMLIST_TEST{318 ,1} = '267_r110';
            IMLIST_TEST{319 ,1} = '267_r150';
            IMLIST_TEST{320 ,1} = '267_r190';
            IMLIST_TEST{321 ,1} = '267_r230';
            IMLIST_TEST{322 ,1} = '267_r270';
            IMLIST_TEST{323 ,1} = '267_r310';
            IMLIST_TEST{324 ,1} = '267_r350';
            IMLIST_TEST{325 ,1} = '282_r30';
            IMLIST_TEST{326, 1} = '282_r70';
            IMLIST_TEST{327 ,1} = '282_r110';
            IMLIST_TEST{328 ,1} = '282_r150';
            IMLIST_TEST{329 ,1} = '282_r190';
            IMLIST_TEST{330 ,1} = '282_r230';
            IMLIST_TEST{331 ,1} = '282_r270';
            IMLIST_TEST{332 ,1} = '282_r310';
            IMLIST_TEST{333 ,1} = '282_r350';
            IMLIST_TEST{334 ,1} = '307_r30';
            IMLIST_TEST{335, 1} = '307_r70';
            IMLIST_TEST{336 ,1} = '307_r110';
            IMLIST_TEST{337 ,1} = '307_r150';
            IMLIST_TEST{338 ,1} = '307_r190';
            IMLIST_TEST{339 ,1} = '307_r230';
            IMLIST_TEST{340 ,1} = '307_r270';
            IMLIST_TEST{341 ,1} = '307_r310';
            IMLIST_TEST{342 ,1} = '307_r350';
            IMLIST_TEST{343 ,1} = '313_r30';
            IMLIST_TEST{344, 1} = '313_r70';
            IMLIST_TEST{345 ,1} = '313_r110';
            IMLIST_TEST{346 ,1} = '313_r150';
            IMLIST_TEST{347 ,1} = '313_r190';
            IMLIST_TEST{348 ,1} = '313_r230';
            IMLIST_TEST{349 ,1} = '313_r270';
            IMLIST_TEST{350 ,1} = '313_r310';
            IMLIST_TEST{351 ,1} = '313_r350';
            IMLIST_TEST{352 ,1} = '357_r30';
            IMLIST_TEST{353, 1} = '357_r70';
            IMLIST_TEST{354 ,1} = '357_r110';
            IMLIST_TEST{355 ,1} = '357_r150';
            IMLIST_TEST{356 ,1} = '357_r190';
            IMLIST_TEST{357 ,1} = '357_r230';
            IMLIST_TEST{358 ,1} = '357_r270';
            IMLIST_TEST{359 ,1} = '357_r310';
            IMLIST_TEST{360 ,1} = '357_r350';
            IMLIST_TEST{361 ,1} = '381_r30';
            IMLIST_TEST{362, 1} = '381_r70';
            IMLIST_TEST{363 ,1} = '381_r110';
            IMLIST_TEST{364 ,1} = '381_r150';
            IMLIST_TEST{365 ,1} = '381_r190';
            IMLIST_TEST{366 ,1} = '381_r230';
            IMLIST_TEST{367 ,1} = '381_r270';
            IMLIST_TEST{368 ,1} = '381_r310';
            IMLIST_TEST{369 ,1} = '381_r350';
            IMLIST_TEST{370 ,1} = '409_r30';
            IMLIST_TEST{371, 1} = '409_r70';
            IMLIST_TEST{372 ,1} = '409_r110';
            IMLIST_TEST{373 ,1} = '409_r150';
            IMLIST_TEST{374 ,1} = '409_r190';
            IMLIST_TEST{375 ,1} = '409_r230';
            IMLIST_TEST{376 ,1} = '409_r270';
            IMLIST_TEST{377 ,1} = '409_r310';
            IMLIST_TEST{378 ,1} = '409_r350';
            IMLIST_TEST{379 ,1} = '503_r30';
            IMLIST_TEST{380, 1} = '503_r70';
            IMLIST_TEST{381 ,1} = '503_r110';
            IMLIST_TEST{382 ,1} = '503_r150';
            IMLIST_TEST{383 ,1} = '503_r190';
            IMLIST_TEST{384 ,1} = '503_r230';
            IMLIST_TEST{385 ,1} = '503_r270';
            IMLIST_TEST{386 ,1} = '503_r310';
            IMLIST_TEST{387 ,1} = '503_r350';
            IMLIST_TEST{388 ,1} = '537_r30';
            IMLIST_TEST{389, 1} = '537_r70';
            IMLIST_TEST{390 ,1} = '537_r110';
            IMLIST_TEST{391 ,1} = '537_r150';
            IMLIST_TEST{392 ,1} = '537_r190';
            IMLIST_TEST{393 ,1} = '537_r230';
            IMLIST_TEST{394 ,1} = '537_r270';
            IMLIST_TEST{395 ,1} = '537_r310';
            IMLIST_TEST{396 ,1} = '537_r350';
            IMLIST_TEST{397 ,1} = '584_r30';
            IMLIST_TEST{398, 1} = '584_r70';
            IMLIST_TEST{399 ,1} = '584_r110';
            IMLIST_TEST{400 ,1} = '584_r150';
            IMLIST_TEST{401 ,1} = '584_r190';
            IMLIST_TEST{402 ,1} = '584_r230';
            IMLIST_TEST{403 ,1} = '584_r270';
            IMLIST_TEST{404 ,1} = '584_r310';
            IMLIST_TEST{405 ,1} = '584_r350';
            IMLIST_TEST{406 ,1} = '610_r30';
            IMLIST_TEST{407, 1} = '610_r70';
            IMLIST_TEST{408 ,1} = '610_r110';
            IMLIST_TEST{409 ,1} = '610_r150';
            IMLIST_TEST{410 ,1} = '610_r190';
            IMLIST_TEST{411 ,1} = '610_r230';
            IMLIST_TEST{412 ,1} = '610_r270';
            IMLIST_TEST{413 ,1} = '610_r310';
            IMLIST_TEST{414 ,1} = '610_r350';
            IMLIST_TEST{415 ,1} = '675_r30';
            IMLIST_TEST{416, 1} = '675_r70';
            IMLIST_TEST{417 ,1} = '675_r110';
            IMLIST_TEST{418 ,1} = '675_r150';
            IMLIST_TEST{419 ,1} = '675_r190';
            IMLIST_TEST{420 ,1} = '675_r230';
            IMLIST_TEST{421 ,1} = '675_r270';
            IMLIST_TEST{422 ,1} = '675_r310';
            IMLIST_TEST{423 ,1} = '675_r350';
            IMLIST_TEST{424 ,1} = '893_r30';
            IMLIST_TEST{425, 1} = '893_r70';
            IMLIST_TEST{426 ,1} = '893_r110';
            IMLIST_TEST{427 ,1} = '893_r150';
            IMLIST_TEST{428 ,1} = '893_r190';
            IMLIST_TEST{429 ,1} = '893_r230';
            IMLIST_TEST{430 ,1} = '893_r270';
            IMLIST_TEST{431 ,1} = '893_r310';
            IMLIST_TEST{432 ,1} = '893_r350';
            IMLIST_TEST{433 ,1} = '910_r30';
            IMLIST_TEST{434, 1} = '910_r70';
            IMLIST_TEST{435 ,1} = '910_r110';
            IMLIST_TEST{436 ,1} = '910_r150';
            IMLIST_TEST{437 ,1} = '910_r190';
            IMLIST_TEST{438 ,1} = '910_r230';
            IMLIST_TEST{439 ,1} = '910_r270';
            IMLIST_TEST{440 ,1} = '910_r310';
            IMLIST_TEST{441 ,1} = '910_r350';
            IMLIST_TEST{442 ,1} = '942_r30';
            IMLIST_TEST{443, 1} = '942_r70';
            IMLIST_TEST{444 ,1} = '942_r110';
            IMLIST_TEST{445 ,1} = '942_r150';
            IMLIST_TEST{446 ,1} = '942_r190';
            IMLIST_TEST{447 ,1} = '942_r230';
            IMLIST_TEST{448 ,1} = '942_r270';
            IMLIST_TEST{449 ,1} = '942_r310';
            IMLIST_TEST{450 ,1} = '942_r350';

            for i = 1 : length(IMLIST_TEST(:,1))
                IMLIST_TEST{i, 2} = floor((i - 1) / N_VIEWS) + 1; % Dimension 2 holds the object number (starting at 1) corersponding to each view
            end

        end % of 'Interpolation ==1' 


    %     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    else
        disp('Not implemented yet: setting ImageSet to 1');
        ImageSet = 1;
    end % of 'if ImageSet == '
end % of function

