function dispRawImage(filename, dim)
    % dispRawImage(filename, dim)
    % e.g.
    % dispRawImage('D:\imagedata\128image_copy\128image_copy\9_r10.filtered\9_r10.original256', 256)
    % dispRawImage('D:\imagedata\128image_copy\128image_copy\9_r10.filtered\9_r10.image', 128)
    % e.g. dispRawImage('/home/erolls/imagedata/cars2/ferrari_7.5', 256)
    % e.g. dispRawImage('/home/erolls/imagedata/jan_calibration/bmw_0.0', 256)
    % e.g. dispRawImage('/home/erolls/imagedata/jan_calibration/bmw_0.0.filtered/bmw_0.0.image', 128)   
    % e.g. dispRawImage('/home/erolls/imagedata/jan_calibration/bmw_0.0.filtered/bmw_0.0.original256', 256)   
    % e.g. dispRawImage('/home/erolls/imagedata/jan_calibration/bmw_0.0.filtered/bmw_0.0.32.0.p',512) % a filtered image
    % e.g. dispRawImage('/home/erolls/imagedata/imagesL3/bmwETR_0.0.filtered/bmwETR_0.0.32.0.p',512) % a filtered image
    % e.g. dispRawImage('/home/erolls/imagedata/faceL/face01L', 256)
    % e.g. dispRawImage('/home/erolls/imagedata/calibration/blackhawk_0.0', 256)        
    % where ferrari_7.5 is a 256 * 256 image 65536 bytes long used for the display image in VisNet
    % Opens the raw binary datafile and interprets it as a square image defined by
    % the dimensions dim * dim.
    % ETR Jan 2013
    
    format compact;
    dims = [dim dim];
    fid = fopen(filename);
    out = fread(fid, dims, '*uint8')';
    fclose(fid);

    out1 = reshape(out, 1, dim * dim);
    size(out1)
    
    minimum = min(out1)
    maximum = max(out1)
    meanval = mean(out1)
    figure(20);
    histar = hist(double(out1), 25);
    plot(histar); title('Histogram of the pixel intensity values'); ylabel('Number of values'); xlabel('Pixel intensity / 10');
    
    figure(21);
    imagesc(out);
    colormap(gray);
    
return;
    
    figure(12);
    [imdata, map, alpha] = imread('vw_van4.png');
    %imdata = imread('house.png');
    s = size(imdata)
    % s(1)
    % s(2)
    
    imdata = rgb2gray(imdata);
    s = size(imdata)
    imagesc(imdata);
    colormap(gray);
    
    imdata1 = reshape(imdata, 1, s(1) * s(2));
    minimum = min(imdata1)
    maximum = max(imdata1)
    meanval = mean(imdata1)
    figure(13);
    histar = hist(double(imdata1), 25);
    plot(histar); title('Histogram of the pixel intensity values'); ylabel('Number of values'); xlabel('Pixel intensity / 10');
    
    figure(14)
    imdata_rs = ((double(imdata) - double(minimum)) ./ double((maximum - minimum))) .*255;
    imdata1_rs = reshape(imdata_rs, 1, s(1) * s(2));
    %for y= 1: s1
    %    for x = 1: s2
    %    imdata1_rs = imdata_rs
    minimum = min(imdata1_rs)
    maximum = max(imdata1_rs)
    meanval = mean(imdata1_rs)
    imagesc(imdata_rs);
    colormap(gray);
    
    figure(15)
    histar = hist(double(imdata1_rs), 25);
    plot(histar); title('Histogram of the pixel intensity values'); ylabel('Number of values'); xlabel('Pixel intensity / 10');
    
    figure(16)
    size(alpha)
    imagesc(alpha);
    colormap(gray);
    
    

    
end