% cd c:/np/doc/VISNET_DOCUMENTATION/VisNetMatlabDoc2014
% clc;    % Clear the command window.
close all;  % Close all figures (except those of imtool.)
imtool close all;  % Close all imtool figures.
clear;  % Erase all existing variables.
workspace;  % Make sure the workspace panel is showing.
%format longg;
format long;
format compact;
fontSize = 20;

% Read in a standard MATLAB gray scale demo image.
folder = fullfile(matlabroot, '\toolbox\images\imdemos');
% button = menu('Use which demo image?', 'CameraMan', 'Moon', 'Eight', 'Coins');
button = 1;
if button == 1
	baseFileName = 'cameraman.tif';
elseif button == 2
	baseFileName = 'moon.tif';
elseif button == 3
	baseFileName = 'eight.tif';
else
	baseFileName = 'coins.png';
end
% Get the full filename, with path prepended.
fullFileName = fullfile(folder, baseFileName);
% Check if file exists.
if ~exist(fullFileName, 'file')
	% File doesn't exist -- didn't find it there.  Check the search path for it.
	fullFileName = baseFileName; % No path this time.
	if ~exist(fullFileName, 'file')
		% Still didn't find it.  Alert user.
		errorMessage = sprintf('Error: %s does not exist in the search path folders.', fullFileName);
		uiwait(warndlg(errorMessage));
		return;
	end
end
grayImage = imread(fullFileName);
% Get the dimensions of the image.  
% numberOfColorBands should be = 1.
[rows columns numberOfColorBands] = size(grayImage);
% Display the original gray scale image.
subplot(2, 2, 1);
imshow(grayImage, []);
title('Original Grayscale Image', 'FontSize', fontSize);
% Enlarge figure to full screen.
set(gcf, 'units','normalized','outerposition',[0 0 1 1]);
% Give a name to the title bar.
set(gcf,'name','Demo by ImageAnalyst','numbertitle','off') 

% Let's compute and display the histogram.
[pixelCount grayLevels] = imhist(grayImage);
subplot(2, 2, 2); 
bar(pixelCount);
grid on;
title('Histogram of Original Image', 'FontSize', fontSize);
xlim([0 grayLevels(end)]); % Scale x axis manually.

disp(['original image mean ' num2str(mean2(grayImage)) ' min ' num2str(min(min(grayImage))) ' max ' num2str(max(max(grayImage)))]);

grayImage = double(grayImage);
max(max(grayImage)) - min(min(grayImage))
m = mean2(grayImage)
%grayImage = grayImage - m;
mean2(grayImage)

%gaussian1 = fspecial('Gaussian', 21, 15); % size of filter, and sd
%gaussian2 = fspecial('Gaussian', 21, 20);
gaussian1 = fspecial('Gaussian', 31, 0.2); % size of filter, and sd
%gaussian2 = fspecial('Gaussian', 31, 8); % the sum is always 1
gaussian2 = fspecial('Gaussian', 31, 4); % the sum is always 1
dog = gaussian1 - gaussian2;
%dog = 1 * gaussian1 - 0.5 * gaussian2;
%dog = 1 * gaussian1 - 0 * gaussian2;
sumdog = sum(sum(dog))
%dog = dog + ((1 - sumdog) / (length(dog) * length(dog))); % ensure that the sum is 1 for no scale change
%dog = dog + ((0 - sumdog) / (length(dog) * length(dog))); % if the sum is zero, the filters will be centred round 0
disp(['sum dog ' num2str(sum(sum(dog)))]); % The sum must be 1 for no scale change

%dogFilterImage = conv2(double(grayImage), dog, 'same');
dogFilterImage = conv2(grayImage, dog, 'same');
%dogFilterImage = dogFilterImage + mean2(grayImage);

subplot(2, 2, 3); 
imshow(dogFilterImage, []);
title('DOG Filtered Image', 'FontSize', fontSize);

% Let's compute and display the histogram.
[pixelCount grayLevels] = hist(dogFilterImage(:));
subplot(2, 2, 4); 
bar(grayLevels, pixelCount);
grid on;
title('Histogram of DOG Filtered Image', 'FontSize', fontSize);

disp(['filtered image mean ' num2str(mean2(dogFilterImage)) ' min ' num2str(min(min(dogFilterImage))) ' max ' num2str(max(max(dogFilterImage)))]);
max(max(dogFilterImage)) - min(min(dogFilterImage))

figure(10);
imagesc(dog);
colormap('gray')
title('Difference of Gaussian filter');
figure(11);
section = dog(:, (floor(length(dog)/2) + 1));
plot(section);
title('Difference of Gaussian filter');
mean2(dog)
sum(sum(dog))
min(min(dog))
max(max(dog))
section
%save dog1_1_0.5_8_sum1.mat dog % scale factor * sd   scale factor * sd  sum
%save dog1_1_0.5_8_sum0.mat dog % scale factor * sd   scale factor * sd  sum
%save dog0.1_1_0.05_8_sum0.mat dog % scale factor * sd   scale factor * sd  sum
%save dog1_0.5_0_8.mat dog % scale factor * sd   scale factor * sd  sum
save dog1_0.2_4.mat dog % scale 1 centre sd=0.2 surround sd=4

